/***********************************************************************/
/*  This file is part of the uVision/ARM development tools             */
/*  Copyright KEIL ELEKTRONIK GmbH 2002-2004                           */
/***********************************************************************/
/*                                                                     */
/*  SYSCALLS.C:  System Calls Remapping                                */
/*                                                                     */
/***********************************************************************/

#include <stdlib.h>


extern int putchar (int ch);

int write (int file, char * ptr, int len) {
  int i;

  for (i = 0; i < len; i++) putchar (*ptr++);
  return len;
}

int isatty (int fd) {
  return 1;
}


void _exit (int n) {
label:  goto label; /* endless loop */
}


register char * stack_ptr asm ("sp");

caddr_t sbrk (int incr) {
  extern char   end asm ("end");	/* Defined by the linker */
  static char * heap_end;
         char * prev_heap_end;

  if (heap_end == NULL) heap_end = &end;
  prev_heap_end = heap_end;

  if (heap_end + incr > stack_ptr) {
    write (1, "sbrk: Heap and stack collision\n", 32);
    abort ();
  }

  heap_end += incr;

  return (caddr_t) prev_heap_end;
}
